<?php 

$title = "Program Management";
$slug="program-management";

include 'inc.header.php'; ?>

<div class="container mt-5">
    <h1 class="text-center">Program Management</h1>
    <p class="text-center fw-bold">Program Setup Status (<a href="">What is Missing?</a>)</p>
    
    <div class="d-flex justify-content-between">
        <span>0%</span>
        <span>100%</span>
    </div>
    <div class="progress mb-4" style="height: 30px;">
        <div class="progress-bar bg-info" role="progressbar" id="progressBar" style="width: 0%; font-size: 1rem;" 
             aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
          0%
        </div>
    </div>
    
    <div class="card">
        <div class="card-body">
            <ul class="nav nav-tabs" id="setupTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="step1-tab" data-bs-toggle="tab" data-bs-target="#step1" type="button" role="tab">Step 1: Scope</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="step2-tab" data-bs-toggle="tab" data-bs-target="#step2" type="button" role="tab">Step 2: Auditor Competencies</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="step3-tab" data-bs-toggle="tab" data-bs-target="#step3" type="button" role="tab">Step 3: Report Settings</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="step4-tab" data-bs-toggle="tab" data-bs-target="#step4" type="button" role="tab">Step 4: Terms</button>
                </li>
            </ul>
            
            <div class="tab-content mt-3" id="setupTabsContent">
                <div class="tab-pane fade show active" id="step1" role="tabpanel">
                    <h3>Scope</h3>
                    <form>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">User ID</label>
                                <input type="text" class="form-control" value="<?=$_SESSION['user_id']?>" readonly>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Company Name</label>
                                <input type="text" class="form-control" value="<?=$_SESSION['company_name']?>" readonly>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">First Name</label>
                                <input type="text" class="form-control" value="<?=$_SESSION['first_name']?>" readonly>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Last Name</label>
                                <input type="text" class="form-control" value="<?=$_SESSION['last_name']?>" readonly>
                            </div>
                        </div>
                    </form>
                    <button class="btn btn-primary next-step" data-bs-target="#step2-tab" data-progress="25">Next</button>
                </div>
                <div class="tab-pane fade" id="step2" role="tabpanel">
                    <h3>Auditor Competencies</h3>
                    <p>Specify the required competencies for auditors.</p>
                    <button class="btn btn-secondary prev-step" data-bs-target="#step1-tab" data-progress="0">Previous</button>
                    <button class="btn btn-primary next-step" data-bs-target="#step3-tab" data-progress="50">Next</button>
                </div>
                <div class="tab-pane fade" id="step3" role="tabpanel">
                    <h3>Report Settings</h3>
                    <p>Configure how reports should be generated.</p>
                    <button class="btn btn-secondary prev-step" data-bs-target="#step2-tab" data-progress="25">Previous</button>
                    <button class="btn btn-primary next-step" data-bs-target="#step4-tab" data-progress="75">Next</button>
                </div>
                <div class="tab-pane fade" id="step4" role="tabpanel">
                    <h3>Terms</h3>
                    <p>Set up the terms and conditions.</p>
                    <button class="btn btn-secondary prev-step" data-bs-target="#step3-tab" data-progress="50">Previous</button>
                    <button class="btn btn-success" data-progress="100">Finish</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('.next-step, .prev-step').forEach(button => {
        button.addEventListener('click', function() {
            let target = this.getAttribute('data-bs-target');
            let progress = this.getAttribute('data-progress');
            
            if (target) {
                let tab = new bootstrap.Tab(document.querySelector(target));
                tab.show();
            }
            
            if (progress) {
                document.getElementById('progressBar').style.width = progress + '%';
                document.getElementById('progressBar').setAttribute('aria-valuenow', progress);
                document.getElementById('progressBar').innerText = progress + '%';
            }
        });
    });
</script>

<?php include 'inc.footer.php'; ?>
